package.path = "./app/lib/?.lua;" .. package.path
require("ucs2")

local LESS = require("app.core.lession")

-- Tests
local function test_short()

	local luid = "./app/test/short"
	local less = LESS.load(luid, "en1", 32)

	assert(less ~= nil)
	
	assert(#less.exem  == 2)
	assert(#less.plc   == 3)
	assert(#less.input == 1)
	
	assert(less:len(1) == ucs2.len(less.exem[1]))
	assert(less:len(2) == ucs2.len(less.exem[2]))
	
	less:push_back(L"ASD")
	assert(less:locate() == 1)
	
	less:push_back(L"ASDF中文ABC")
	assert(less:locate() == 2)

	less:push_back(L"中文ABC")
	assert(less:locate() == 2)
	
	less:push_back(L"中文ABCXYZ")
	assert(less:locate() == 2)
	
	less:pop_back()
	less:pop_back()
	less:pop_back()
	less:pop_back()
	less:pop_back()
	
	assert(less:locate() == 2)
	assert(less:si(1) == L"ASDF")
	assert(less:si(2) == L"")
	
	less:pop_back()
	assert(less:locate() == 1)
	assert(less:si(1) == L"ASD")

	less:pop_back()
	less:pop_back()
	less:pop_back()
	assert(less:si(1) == L"")
	assert(#less.input == 1)

	less:pop_back()
	assert(less:si(1) == L"")
	assert(#less.input == 1)
	assert(less:diff(1) == "")

	less:push_back(L"ASD")
	assert(less:locate() == 1)
	assert(less:diff(1) == L"sss")
	
	less:push_back(L"ASDC")
	assert(less:diff(1) == L"sssd")
	assert(less:diff(less:locate()) == L"")

end


local function test_long()
	
	local luid = "./app/test/ATaleofTwoCities"
	local less = LESS.load(luid, "en1", 32)

	assert(less ~= nil)

	assert(ucs2.len(less:se(1)) == 32)
	assert(ucs2.len(less:se(2)) == 32)
	assert(ucs2.len(less:se(3)) == 32)
	assert(ucs2.len(less:se(4)) == 32)
	assert(ucs2.len(less:se(5)) == 32)
	assert(ucs2.len(less:se(6)) == 32)
	
	assert(less:si(5) == L"")
end


local function test_update()

	local luid = "./app/test/ATaleofTwoCities"
	local less = L.load(luid)

	assert(less ~= nil)

	less:update(1, "test")
	assert(less:ip(1), "test")
	
end


local function test_nextch()

	local luid = "./app/test/short"
	local less = LESS.load(luid, "en1", 32)

	assert(less ~= nil)

	assert(less:nextch() == L"A")
	less:push_back(L"AS")	
	assert(less:nextch() == L"D")

	less:push_back(L"ASD")	
	assert(less:nextch() == L"F")

	less:push_back(L"ASDF")	
	assert(less:nextch() == L"中")
end

-- Run Tests
print(pcall(test_short))
print(pcall(test_long))
--print(pcall(test_update))
print(pcall(test_nextch))
